/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.resource.ammobench;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import dev.toma.gunsrpg.resource.ammobench.AmmoBenchOutputCount;
import dev.toma.gunsrpg.resource.ammobench.AmmoBenchOutputCountType;
import dev.toma.gunsrpg.util.helper.JsonHelper;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;

public class MulRangeOutputCount
implements AmmoBenchOutputCount {
    private static final Random RANDOM = new Random();
    private final float multiplier;
    @Nullable
    private final Float chance;

    public MulRangeOutputCount(float multiplier, @Nullable Float chance) {
        this.multiplier = multiplier;
        this.chance = chance;
    }

    @Override
    public int getCount(int count) {
        if (this.chance != null && RANDOM.nextFloat() >= this.chance.floatValue()) {
            return count;
        }
        return (int)((float)count * this.multiplier);
    }

    @Override
    public AmmoBenchOutputCountType<?> getType() {
        return AmmoBenchOutputCountType.MUL;
    }

    public static final class Serializer
    implements AmmoBenchOutputCountType.AmmoBenchOutputCountSerializer<MulRangeOutputCount> {
        @Override
        public MulRangeOutputCount parseJson(JsonElement element) throws JsonParseException {
            JsonObject object = JsonHelper.asJsonObject(element);
            float multiplier = JSONUtils.func_151217_k((JsonObject)object, (String)"value");
            Float chance = JsonHelper.optionally(object, "chance", JSONUtils::func_151217_k).orElse(null);
            return new MulRangeOutputCount(multiplier, chance);
        }

        @Override
        public void toNetwork(MulRangeOutputCount mulRangeOutputCount, PacketBuffer buffer) {
            buffer.writeFloat(mulRangeOutputCount.multiplier);
            buffer.writeBoolean(mulRangeOutputCount.chance != null);
            if (mulRangeOutputCount.chance != null) {
                buffer.writeFloat(mulRangeOutputCount.chance.floatValue());
            }
        }

        @Override
        public MulRangeOutputCount fromNetwork(PacketBuffer buffer) {
            float value = buffer.readFloat();
            Float chance = buffer.readBoolean() ? Float.valueOf(buffer.readFloat()) : null;
            return new MulRangeOutputCount(value, chance);
        }

        @Override
        public CompoundNBT toNbt(MulRangeOutputCount mulRangeOutputCount) {
            CompoundNBT nbt = new CompoundNBT();
            nbt.func_74776_a("value", mulRangeOutputCount.multiplier);
            if (mulRangeOutputCount.chance != null) {
                nbt.func_74776_a("chance", mulRangeOutputCount.chance.floatValue());
            }
            return nbt;
        }

        @Override
        public MulRangeOutputCount fromNbt(CompoundNBT nbt) {
            float value = nbt.func_74760_g("value");
            Float chance = nbt.func_74764_b("chance") ? Float.valueOf(nbt.func_74760_g("chance")) : null;
            return new MulRangeOutputCount(value, chance);
        }
    }
}

